/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.wizards;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.github.IGithubUser;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.preferences.GithubAccountPageProvider;
import com.aptana.git.ui.internal.wizards.Messages;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class RepositorySelectionPage
extends WizardPage {
    private static final String DEFAULT_GIT_URI = "git://github.com/{0}/example.git";
    private static final String USER = "user";
    private static final String USER_NAME = "user.name";
    private String sourceURI;
    private String destination;
    private GithubAccountPageProvider userInfoProvider;
    private Control userInfoControl;
    private Combo githubReposCombo;
    private Text sourceURIText;
    private Text destinationText;
    private Button fromGithub;
    private Button fromURI;

    protected RepositorySelectionPage() {
        super(RepositorySelectionPage.class.getName());
        this.setTitle(Messages.RepositorySelectionPage_Title);
        this.setDescription(Messages.RepositorySelectionPage_Description);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        GridDataFactory inputData = GridDataFactory.swtDefaults().hint(300, -1);
        this.userInfoProvider = new GithubAccountPageProvider();
        this.userInfoControl = this.userInfoProvider.createContents(main);
        this.userInfoControl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        this.userInfoProvider.addListener(new GithubAccountPageProvider.GithubListener(){

            public void loggedIn() {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        RepositorySelectionPage.this.fromGithub.setEnabled(true);
                        RepositorySelectionPage.this.reloadGithubRepos();
                        RepositorySelectionPage.this.updateSourceURIText();
                        RepositorySelectionPage.this.updateSourceURI();
                    }
                });
            }

            public void loggedOut() {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        RepositorySelectionPage.this.reloadGithubRepos();
                        RepositorySelectionPage.this.fromGithub.setEnabled(false);
                        RepositorySelectionPage.this.fromGithub.setSelection(false);
                        RepositorySelectionPage.this.fromURI.setSelection(true);
                        RepositorySelectionPage.this.updateEnablement();
                        RepositorySelectionPage.this.updateSourceURIText();
                        RepositorySelectionPage.this.updateSourceURI();
                    }
                });
            }
        });
        IGithubManager manager = this.getGithubManager();
        IGithubUser user = manager.getUser();
        this.fromGithub = new Button(main, 16);
        this.fromGithub.setText(StringUtil.makeFormLabel((String)Messages.RepositorySelectionPage_LBL_Github));
        this.fromGithub.setEnabled(user != null);
        this.fromGithub.setSelection(user != null);
        this.fromGithub.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionPage.this.updateSourceURI();
                RepositorySelectionPage.this.updateEnablement();
            }
        });
        this.githubReposCombo = new Combo(main, 12);
        this.githubReposCombo.setLayoutData((Object)inputData.create());
        this.reloadGithubRepos();
        new Label(main, 0);
        this.fromURI = new Button(main, 16);
        this.fromURI.setText(Messages.RepositorySelectionPage_SourceURI_Label);
        this.fromURI.setSelection(user == null);
        this.fromURI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositorySelectionPage.this.updateSourceURI();
                RepositorySelectionPage.this.updateEnablement();
            }
        });
        this.sourceURIText = new Text(main, 2052);
        this.sourceURIText.setLayoutData((Object)inputData.create());
        this.updateSourceURIText();
        this.sourceURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.updateURI(RepositorySelectionPage.this.sourceURIText.getText());
            }
        });
        new Label(main, 0);
        Label dest = new Label(main, 0);
        dest.setText(Messages.RepositorySelectionPage_Destination_Label);
        this.destinationText = new Text(main, 2052);
        this.destinationText.setLayoutData((Object)inputData.create());
        this.destinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositorySelectionPage.this.validate();
            }
        });
        Button destinationButton = new Button(main, 8);
        destinationButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        destinationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r;
                FileDialog d = new FileDialog(RepositorySelectionPage.this.getShell(), 73728);
                String text = RepositorySelectionPage.this.destinationText.getText();
                if (!StringUtil.isEmpty((String)text)) {
                    File file = new File(text).getAbsoluteFile();
                    d.setFilterPath(file.getParent());
                    d.setFileName(file.getName());
                }
                if ((r = d.open()) != null) {
                    RepositorySelectionPage.this.destinationText.setText(r);
                }
            }
        });
        this.updateSourceURI();
        this.updateEnablement();
        this.setErrorMessage(null);
        this.setControl((Control)main);
    }

    private void updateSourceURIText() {
        String username;
        IGithubUser user = this.getGithubManager().getUser();
        String string = username = user == null ? System.getProperty(USER_NAME) : user.getUsername();
        if (StringUtil.isEmpty((String)username)) {
            username = USER;
        }
        this.sourceURIText.setMessage(MessageFormat.format(DEFAULT_GIT_URI, username));
    }

    protected void updateSourceURI() {
        String uri = this.fromGithub.getSelection() ? this.githubReposCombo.getText() : this.sourceURIText.getText();
        this.updateURI(uri);
    }

    protected void updateURI(String uri) {
        this.sourceURI = uri;
        if (this.sourceURI != null) {
            String workspacePath = this.generateDestinationPath(this.sourceURI);
            this.destinationText.setText(workspacePath);
        }
        this.validate();
    }

    private void validate() {
        if (StringUtil.isEmpty((String)this.sourceURI)) {
            this.setErrorMessage(Messages.RepositorySelectionPage_SourceURIRequired_Message);
            this.setPageComplete(false);
            return;
        }
        String dstpath = this.destinationText.getText();
        if (StringUtil.isEmpty((String)dstpath)) {
            this.setErrorMessage(Messages.RepositorySelectionPage_DestinatioNRequired_Message);
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!RepositorySelectionPage.isEmptyDir(absoluteFile)) {
            this.setErrorMessage(NLS.bind((String)Messages.RepositorySelectionPage_DirectoryExists_ErrorMessage, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!RepositorySelectionPage.canCreateSubdir(absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)Messages.RepositorySelectionPage_CannotCreateDirectory_ErrorMessage, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        this.destination = dstpath;
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void reloadGithubRepos() {
        IGithubManager manager = this.getGithubManager();
        IGithubUser user = manager.getUser();
        if (user == null) {
            this.githubReposCombo.removeAll();
        } else {
            try {
                List repoList = user.getAllRepos();
                if (!CollectionsUtil.isEmpty((Collection)repoList)) {
                    for (IGithubRepository repo : repoList) {
                        this.githubReposCombo.add(repo.getSSHURL());
                    }
                    this.githubReposCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositorySelectionPage.this.updateURI(RepositorySelectionPage.this.githubReposCombo.getText());
                        }
                    });
                    this.githubReposCombo.select(0);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    private IGithubManager getGithubManager() {
        return GitPlugin.getDefault().getGithubManager();
    }

    private static boolean isEmptyDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        return dir.listFiles().length == 0;
    }

    private static boolean canCreateSubdir(File parent) {
        if (parent == null) {
            return true;
        }
        if (parent.exists()) {
            return parent.isDirectory() && parent.canWrite();
        }
        return RepositorySelectionPage.canCreateSubdir(parent.getParentFile());
    }

    public String getSource() {
        return this.sourceURI;
    }

    public String getDestination() {
        return this.destination;
    }

    protected String generateDestinationPath(String uri) {
        int slash;
        String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        int index = uri.lastIndexOf(".git");
        if (index == -1) {
            index = uri.length();
        }
        if ((slash = uri.lastIndexOf(47, index)) != -1) {
            workspacePath = String.valueOf(workspacePath) + File.separator + uri.substring(slash + 1, index);
        }
        return workspacePath;
    }

    private void updateEnablement() {
        boolean isFromGithub = this.fromGithub.getSelection();
        this.githubReposCombo.setEnabled(isFromGithub);
        this.sourceURIText.setEnabled(!isFromGithub);
    }
}

